//
// DirectoryWatcherTest.h
//
// $Id: //poco/1.4/Foundation/testsuite/src/DirectoryWatcherTest.h#1 $
//
// Definition of the DirectoryWatcherTest class.
//
// Copyright (c) 2012, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef DirectoryWatcherTest_INCLUDED
#define DirectoryWatcherTest_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/DirectoryWatcher.h"
#include "Poco/Path.h"
#include "CppUnit/TestCase.h"


class DirectoryWatcherTest: public CppUnit::TestCase
{
public:
	DirectoryWatcherTest(const std::string& name);
	~DirectoryWatcherTest();

	void testAdded();
	void testRemoved();
	void testModified();
	void testMoved();
	
	void setUp();
	void tearDown();

	static CppUnit::Test* suite();
	
protected:
	void onItemAdded(const Poco::DirectoryWatcher::DirectoryEvent& ev);
	void onItemRemoved(const Poco::DirectoryWatcher::DirectoryEvent& ev);
	void onItemModified(const Poco::DirectoryWatcher::DirectoryEvent& ev);
	void onItemMovedFrom(const Poco::DirectoryWatcher::DirectoryEvent& ev);
	void onItemMovedTo(const Poco::DirectoryWatcher::DirectoryEvent& ev);
	void onError(const Poco::Exception& exc);
	
	Poco::Path path() const;

private:
	struct DirEvent
	{
		Poco::DirectoryWatcher::DirectoryEventType type;
		std::string callback;
		std::string path;
	};
	std::vector<DirEvent> _events;
	bool _error;
};


#endif // DirectoryWatcherTest_INCLUDED
