//
// ObjectPoolTest.cpp
//
// $Id: //poco/1.4/Foundation/testsuite/src/ObjectPoolTest.cpp#1 $
//
// Copyright (c) 2010-2012, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "ObjectPoolTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/ObjectPool.h"
#include "Poco/Exception.h"


using Poco::ObjectPool;


ObjectPoolTest::ObjectPoolTest(const std::string& name): CppUnit::TestCase(name)
{
}


ObjectPoolTest::~ObjectPoolTest()
{
}


void ObjectPoolTest::testObjectPool()
{
	ObjectPool<std::string, Poco::SharedPtr<std::string> > pool(3, 4);
	
	assert (pool.capacity() == 3);
	assert (pool.peakCapacity() == 4);
	assert (pool.size() == 0);
	assert (pool.available() == 4);
	
	Poco::SharedPtr<std::string> pStr1 = pool.borrowObject();
	pStr1->assign("first");
	assert (pool.size() == 1);
	assert (pool.available() == 3);
	
	Poco::SharedPtr<std::string> pStr2 = pool.borrowObject();
	pStr2->assign("second");
	assert (pool.size() == 2);
	assert (pool.available() == 2);

	Poco::SharedPtr<std::string> pStr3 = pool.borrowObject();
	pStr3->assign("third");
	assert (pool.size() == 3);
	assert (pool.available() == 1);
	
	Poco::SharedPtr<std::string> pStr4 = pool.borrowObject();
	pStr4->assign("fourth");
	assert (pool.size() == 4);
	assert (pool.available() == 0);
	
	Poco::SharedPtr<std::string> pStr5 = pool.borrowObject();
	assert (pStr5.isNull());
	
	pool.returnObject(pStr4);
	assert (pool.size() == 4);
	assert (pool.available() == 1);
	
	pool.returnObject(pStr3);
	assert (pool.size() == 4);
	assert (pool.available() == 2);

	pStr3 = pool.borrowObject();
	assert (*pStr3 == "third");
	assert (pool.available() == 1);

	pool.returnObject(pStr3);
	pool.returnObject(pStr2);
	pool.returnObject(pStr1);
	
	assert (pool.size() == 3);
	assert (pool.available() == 4);
	
	pStr1 = pool.borrowObject();
	assert (*pStr1 == "second");
	assert (pool.available() == 3);

	pool.returnObject(pStr1);
	assert (pool.available() == 4);
}


void ObjectPoolTest::setUp()
{
}


void ObjectPoolTest::tearDown()
{
}


CppUnit::Test* ObjectPoolTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("ObjectPoolTest");

	CppUnit_addTest(pSuite, ObjectPoolTest, testObjectPool);

	return pSuite;
}
