//
// DigestEngine.cpp
//
// $Id: //poco/1.4/Crypto/src/DigestEngine.cpp#1 $
//
// Library: Crypto
// Package: Digest
// Module:  DigestEngine
//
// Copyright (c) 2012, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Crypto/DigestEngine.h"
#include "Poco/Exception.h"


namespace Poco {
namespace Crypto {


DigestEngine::DigestEngine(const std::string& name):
	_name(name)
{
	const EVP_MD* md = EVP_get_digestbyname(_name.c_str());
	if (!md) throw Poco::NotFoundException(_name);
	_ctx = EVP_MD_CTX_create();
	EVP_DigestInit_ex(_ctx, md, NULL);	
}

	
DigestEngine::~DigestEngine()
{
	EVP_MD_CTX_destroy(_ctx);
}


unsigned DigestEngine::digestLength() const
{
	return EVP_MD_CTX_size(_ctx);
}


void DigestEngine::reset()
{
	EVP_MD_CTX_cleanup(_ctx);
	const EVP_MD* md = EVP_get_digestbyname(_name.c_str());
	if (!md) throw Poco::NotFoundException(_name);
	EVP_DigestInit_ex(_ctx, md, NULL);
}


const Poco::DigestEngine::Digest& DigestEngine::digest()
{
	_digest.clear();
	unsigned len = EVP_MD_CTX_size(_ctx);
	_digest.resize(len);
	EVP_DigestFinal_ex(_ctx, &_digest[0], &len);
	reset();
	return _digest;
}


void DigestEngine::updateImpl(const void* data, unsigned length)
{
	EVP_DigestUpdate(_ctx, data, length);
}


} } // namespace Poco::Crypto
